<?php
require_once( dirname(__FILE__).'/form.lib.php' );

define( 'PHPFMG_USER', "haris.s@hucodigital.com" ); // must be a email address. for sending password to you.
define( 'PHPFMG_PW', "02419c" );

?>
<?php
/**
 * GNU Library or Lesser General Public License version 2.0 (LGPLv2)
*/

# main
# ------------------------------------------------------
error_reporting( E_ERROR ) ;
phpfmg_admin_main();
# ------------------------------------------------------




function phpfmg_admin_main(){
    $mod  = isset($_REQUEST['mod'])  ? $_REQUEST['mod']  : '';
    $func = isset($_REQUEST['func']) ? $_REQUEST['func'] : '';
    $function = "phpfmg_{$mod}_{$func}";
    if( !function_exists($function) ){
        phpfmg_admin_default();
        exit;
    };

    // no login required modules
    $public_modules   = false !== strpos('|captcha||ajax|', "|{$mod}|");
    $public_functions = false !== strpos('|phpfmg_ajax_submit||phpfmg_mail_request_password||phpfmg_filman_download||phpfmg_image_processing||phpfmg_dd_lookup|', "|{$function}|") ;   
    if( $public_modules || $public_functions ) { 
        $function();
        exit;
    };
    
    return phpfmg_user_isLogin() ? $function() : phpfmg_admin_default();
}

function phpfmg_ajax_submit(){
    $phpfmg_send = phpfmg_sendmail( $GLOBALS['form_mail'] );
    $isHideForm  = isset($phpfmg_send['isHideForm']) ? $phpfmg_send['isHideForm'] : false;

    $response = array(
        'ok' => $isHideForm,
        'error_fields' => isset($phpfmg_send['error']) ? $phpfmg_send['error']['fields'] : '',
        'OneEntry' => isset($GLOBALS['OneEntry']) ? $GLOBALS['OneEntry'] : '',
    );
    
    @header("Content-Type:text/html; charset=$charset");
    echo "<html><body><script>
    var response = " . json_encode( $response ) . ";
    try{
        parent.fmgHandler.onResponse( response );
    }catch(E){};
    \n\n";
    echo "\n\n</script></body></html>";

}


function phpfmg_admin_default(){
    if( phpfmg_user_login() ){
        phpfmg_admin_panel();
    };
}



function phpfmg_admin_panel()
{    
    if( !phpfmg_user_isLogin() ){
        exit;
    };

    phpfmg_admin_header();
    phpfmg_writable_check();
?>    
<table cellpadding="0" cellspacing="0" border="0">
	<tr>
		<td valign=top style="padding-left:280px;">

<style type="text/css">
    .fmg_title{
        font-size: 16px;
        font-weight: bold;
        padding: 10px;
    }
    
    .fmg_sep{
        width:32px;
    }
    
    .fmg_text{
        line-height: 150%;
        vertical-align: top;
        padding-left:28px;
    }

</style>

<script type="text/javascript">
    function deleteAll(n){
        if( confirm("Are you sure you want to delete?" ) ){
            location.href = "admin.php?mod=log&func=delete&file=" + n ;
        };
        return false ;
    }
</script>


<div class="fmg_title">
    1. Email Traffics
</div>
<div class="fmg_text">
    <a href="admin.php?mod=log&func=view&file=1">view</a> &nbsp;&nbsp;
    <a href="admin.php?mod=log&func=download&file=1">download</a> &nbsp;&nbsp;
    <?php 
        if( file_exists(PHPFMG_EMAILS_LOGFILE) ){
            echo '<a href="#" onclick="return deleteAll(1);">delete all</a>';
        };
    ?>
</div>


<div class="fmg_title">
    2. Form Data
</div>
<div class="fmg_text">
    <a href="admin.php?mod=log&func=view&file=2">view</a> &nbsp;&nbsp;
    <a href="admin.php?mod=log&func=download&file=2">download</a> &nbsp;&nbsp;
    <?php 
        if( file_exists(PHPFMG_SAVE_FILE) ){
            echo '<a href="#" onclick="return deleteAll(2);">delete all</a>';
        };
    ?>
</div>

<div class="fmg_title">
    3. Form Generator
</div>
<div class="fmg_text">
    <a href="http://www.formmail-maker.com/generator.php" onclick="document.frmFormMail.submit(); return false;" title="<?php echo htmlspecialchars(PHPFMG_SUBJECT);?>">Edit Form</a> &nbsp;&nbsp;
    <a href="http://www.formmail-maker.com/generator.php" >New Form</a>
</div>
    <form name="frmFormMail" action='http://www.formmail-maker.com/generator.php' method='post' enctype='multipart/form-data'>
    <input type="hidden" name="uuid" value="<?php echo PHPFMG_ID; ?>">
    <input type="hidden" name="external_ini" value="<?php echo function_exists('phpfmg_formini') ?  phpfmg_formini() : ""; ?>">
    </form>

		</td>
	</tr>
</table>

<?php
    phpfmg_admin_footer();
}



function phpfmg_admin_header( $title = '' ){
    header( "Content-Type: text/html; charset=" . PHPFMG_CHARSET );
?>
<html>
<head>
    <title><?php echo '' == $title ? '' : $title . ' | ' ; ?>PHP FormMail Admin Panel </title>
    <meta name="keywords" content="PHP FormMail Generator, PHP HTML form, send html email with attachment, PHP web form,  Free Form, Form Builder, Form Creator, phpFormMailGen, Customized Web Forms, phpFormMailGenerator,formmail.php, formmail.pl, formMail Generator, ASP Formmail, ASP form, PHP Form, Generator, phpFormGen, phpFormGenerator, anti-spam, web hosting">
    <meta name="description" content="PHP formMail Generator - A tool to ceate ready-to-use web forms in a flash. Validating form with CAPTCHA security image, send html email with attachments, send auto response email copy, log email traffics, save and download form data in Excel. ">
    <meta name="generator" content="PHP Mail Form Generator, phpfmg.sourceforge.net">

    <style type='text/css'>
    body, td, label, div, span{
        font-family : Verdana, Arial, Helvetica, sans-serif;
        font-size : 12px;
    }
    </style>
</head>
<body  marginheight="0" marginwidth="0" leftmargin="0" topmargin="0">

<table cellspacing=0 cellpadding=0 border=0 width="100%">
    <td nowrap align=center style="background-color:#024e7b;padding:10px;font-size:18px;color:#ffffff;font-weight:bold;width:250px;" >
        Form Admin Panel
    </td>
    <td style="padding-left:30px;background-color:#86BC1B;width:100%;font-weight:bold;" >
        &nbsp;
<?php
    if( phpfmg_user_isLogin() ){
        echo '<a href="admin.php" style="color:#ffffff;">Main Menu</a> &nbsp;&nbsp;' ;
        echo '<a href="admin.php?mod=user&func=logout" style="color:#ffffff;">Logout</a>' ;
    }; 
?>
    </td>
</table>

<div style="padding-top:28px;">

<?php
    
}


function phpfmg_admin_footer(){
?>

</div>

<div style="color:#cccccc;text-decoration:none;padding:18px;font-weight:bold;">
	:: <a href="http://phpfmg.sourceforge.net" target="_blank" title="Free Mailform Maker: Create read-to-use Web Forms in a flash. Including validating form with CAPTCHA security image, send html email with attachments, send auto response email copy, log email traffics, save and download form data in Excel. " style="color:#cccccc;font-weight:bold;text-decoration:none;">PHP FormMail Generator</a> ::
</div>

</body>
</html>
<?php
}


function phpfmg_image_processing(){
    $img = new phpfmgImage();
    $img->out_processing_gif();
}


# phpfmg module : captcha
# ------------------------------------------------------
function phpfmg_captcha_get(){
    $img = new phpfmgImage();
    $img->out();
    //$_SESSION[PHPFMG_ID.'fmgCaptchCode'] = $img->text ;
    $_SESSION[ phpfmg_captcha_name() ] = $img->text ;
}



function phpfmg_captcha_generate_images(){
    for( $i = 0; $i < 50; $i ++ ){
        $file = "$i.png";
        $img = new phpfmgImage();
        $img->out($file);
        $data = base64_encode( file_get_contents($file) );
        echo "'{$img->text}' => '{$data}',\n" ;
        unlink( $file );
    };
}


function phpfmg_dd_lookup(){
    $paraOk = ( isset($_REQUEST['n']) && isset($_REQUEST['lookup']) && isset($_REQUEST['field_name']) );
    if( !$paraOk )
        return;
        
    $base64 = phpfmg_dependent_dropdown_data();
    $data = @unserialize( base64_decode($base64) );
    if( !is_array($data) ){
        return ;
    };
    
    
    foreach( $data as $field ){
        if( $field['name'] == $_REQUEST['field_name'] ){
            $nColumn = intval($_REQUEST['n']);
            $lookup  = $_REQUEST['lookup']; // $lookup is an array
            $dd      = new DependantDropdown(); 
            echo $dd->lookupFieldColumn( $field, $nColumn, $lookup );
            return;
        };
    };
    
    return;
}


function phpfmg_filman_download(){
    if( !isset($_REQUEST['filelink']) )
        return ;
        
    $filelink =  base64_decode($_REQUEST['filelink']);
    $file = PHPFMG_SAVE_ATTACHMENTS_DIR . basename($filelink);

    // 2016-12-05:  to prevent *LFD/LFI* attack. patch provided by Pouya Darabi, a security researcher in cert.org
    $real_basePath = realpath(PHPFMG_SAVE_ATTACHMENTS_DIR); 
    $real_requestPath = realpath($file);
    if ($real_requestPath === false || strpos($real_requestPath, $real_basePath) !== 0) { 
        return; 
    }; 

    if( !file_exists($file) ){
        return ;
    };
    
    phpfmg_util_download( $file, $filelink );
}


class phpfmgDataManager
{
    var $dataFile = '';
    var $columns = '';
    var $records = '';
    
    function __construct(){
        $this->dataFile = PHPFMG_SAVE_FILE; 
    }

    function phpfmgDataManager(){
        $this->dataFile = PHPFMG_SAVE_FILE; 
    }
    
    function parseFile(){
        $fp = @fopen($this->dataFile, 'rb');
        if( !$fp ) return false;
        
        $i = 0 ;
        $phpExitLine = 1; // first line is php code
        $colsLine = 2 ; // second line is column headers
        $this->columns = array();
        $this->records = array();
        $sep = chr(0x09);
        while( !feof($fp) ) { 
            $line = fgets($fp);
            $line = trim($line);
            if( empty($line) ) continue;
            $line = $this->line2display($line);
            $i ++ ;
            switch( $i ){
                case $phpExitLine:
                    continue;
                    break;
                case $colsLine :
                    $this->columns = explode($sep,$line);
                    break;
                default:
                    $this->records[] = explode( $sep, phpfmg_data2record( $line, false ) );
            };
        }; 
        fclose ($fp);
    }
    
    function displayRecords(){
        $this->parseFile();
        echo "<table border=1 style='width=95%;border-collapse: collapse;border-color:#cccccc;' >";
        echo "<tr><td>&nbsp;</td><td><b>" . join( "</b></td><td>&nbsp;<b>", $this->columns ) . "</b></td></tr>\n";
        $i = 1;
        foreach( $this->records as $r ){
            echo "<tr><td align=right>{$i}&nbsp;</td><td>" . join( "</td><td>&nbsp;", $r ) . "</td></tr>\n";
            $i++;
        };
        echo "</table>\n";
    }
    
    function line2display( $line ){
        $line = str_replace( array('"' . chr(0x09) . '"', '""'),  array(chr(0x09),'"'),  $line );
        $line = substr( $line, 1, -1 ); // chop first " and last "
        return $line;
    }
    
}
# end of class



# ------------------------------------------------------
class phpfmgImage
{
    var $im = null;
    var $width = 73 ;
    var $height = 33 ;
    var $text = '' ; 
    var $line_distance = 8;
    var $text_len = 4 ;

    function __construct( $text = '', $len = 4 ){
        $this->phpfmgImage( $text, $len );
    }

    function phpfmgImage( $text = '', $len = 4 ){
        $this->text_len = $len ;
        $this->text = '' == $text ? $this->uniqid( $this->text_len ) : $text ;
        $this->text = strtoupper( substr( $this->text, 0, $this->text_len ) );
    }
    
    function create(){
        $this->im = imagecreate( $this->width, $this->height );
        $bgcolor   = imagecolorallocate($this->im, 255, 255, 255);
        $textcolor = imagecolorallocate($this->im, 0, 0, 0);
        $this->drawLines();
        imagestring($this->im, 5, 20, 9, $this->text, $textcolor);
    }
    
    function drawLines(){
        $linecolor = imagecolorallocate($this->im, 210, 210, 210);
    
        //vertical lines
        for($x = 0; $x < $this->width; $x += $this->line_distance) {
          imageline($this->im, $x, 0, $x, $this->height, $linecolor);
        };
    
        //horizontal lines
        for($y = 0; $y < $this->height; $y += $this->line_distance) {
          imageline($this->im, 0, $y, $this->width, $y, $linecolor);
        };
    }
    
    function out( $filename = '' ){
        if( function_exists('imageline') ){
            $this->create();
            if( '' == $filename ) header("Content-type: image/png");
            ( '' == $filename ) ? imagepng( $this->im ) : imagepng( $this->im, $filename );
            imagedestroy( $this->im ); 
        }else{
            $this->out_predefined_image(); 
        };
    }

    function uniqid( $len = 0 ){
        $md5 = md5( uniqid(rand()) );
        return $len > 0 ? substr($md5,0,$len) : $md5 ;
    }
    
    function out_predefined_image(){
        header("Content-type: image/png");
        $data = $this->getImage(); 
        echo base64_decode($data);
    }
    
    // Use predefined captcha random images if web server doens't have GD graphics library installed  
    function getImage(){
        $images = array(
			'39BA' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAbUlEQVR4nGNYhQEaGAYTpIn7RAMYQ1hDGVqRxQKmsLayNjpMdUBW2SrS6NoQEBCALDYFKNbo6CCC5L6VUUuXpoauzJqG7L4pjIFI6qDmMQDNCwwNQRFjAYmhqIO4BVUvxM2MqOYNUPhREWJxHwCfrMxcg4NebQAAAABJRU5ErkJggg==',
			'690A' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAcUlEQVR4nGNYhQEaGAYTpIn7WAMYQximMLQii4lMYW1lCGWY6oAkFtAi0ujo6BAQgCzWINLo2hDoIILkvsiopUtTV0VmTUNyX8gUxkAkdRC9rQwgvaEhKGIsQDscUdRB3MKIIgZxM6rYQIUfFSEW9wEAK67MAk1B3MkAAAAASUVORK5CYII=',
			'EEAC' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAXklEQVR4nGNYhQEaGAYTpIn7QkNEQxmmMEwNQBILaBBpYAhlCBBBE2N0dHRgQRNjbQh0QHZfaNTUsKWrIrOQ3YemDiEWikUMqA7TjgAUt4DcDBRDcfNAhR8VIRb3AQB0BMygiLTAMAAAAABJRU5ErkJggg==',
			'CA82' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAdElEQVR4nGNYhQEaGAYTpIn7WEMYAhhCGaY6IImJtDKGMDo6BAQgiQU0srayNgQ6iCCLNYg0Ojo6NIgguS9q1bSVWaEgGuE+qLpGBxS9oqGuDQGtDCh2iDQCxaYwoLgFrDcA1c0ijQ6hjKEhgyD8qAixuA8ASp/NVsaraCIAAAAASUVORK5CYII=',
			'B664' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAZ0lEQVR4nGNYhQEaGAYTpIn7QgMYQxhCGRoCkMQCprC2Mjo6NKKItYo0sjY4tKKqE2lgbWCYEoDkvtCoaWFLp66KikJyX8AU0VZWR0cHdPNcGwJDQzDEArC5BUUMm5sHKvyoCLG4DwDKRM8vfwzrbgAAAABJRU5ErkJggg==',
			'7816' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAb0lEQVR4nGNYhQEaGAYTpIn7QkMZQximMEx1QBZtZW1lCGEICEARE2l0DGF0EEAWmwJUN4XRAcV9USvDVk1bmZqF5D5GB7A6FPNYG0QaHYB6RZDERLCIBTSA9KK6JaCBMYQx1AHVzQMUflSEWNwHAILnyxfFJCT8AAAAAElFTkSuQmCC',
			'0B51' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAaElEQVR4nGNYhQEaGAYTpIn7GB1EQ1hDHVqRxVgDRFpZGximIouJTBFpdG1gCEUWC2gFqpvKANMLdlLU0qlhSzOzliK7D6QORKLpbXRAE4PYEYDhFkZHVPeB3Ax0SWjAIAg/KkIs7gMAsWTL4xi+YzUAAAAASUVORK5CYII=',
			'0617' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAbklEQVR4nGNYhQEaGAYTpIn7GB0YQximMIaGIImxBrC2MoQwNIggiYlMEWlkRBMLaAXypgBpJPdFLZ0WtmraqpVZSO4LaBVtBaprZUDV2+gwBaQb1Q6gWAADulumMDqgu5kx1BFFbKDCj4oQi/sAUUnKnZ16gAAAAAAASUVORK5CYII=',
			'E4B3' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAYklEQVR4nGNYhQEaGAYTpIn7QkMYWllDGUIdkMQCGhimsjY6OgSgioWyAkkRFDFGV9ZGh4YAJPeFRi1dujR01dIsJPcBdbUiqYOKiYa6YpgHdAs2MTS3YHPzQIUfFSEW9wEA7JPOc5SP4S4AAAAASUVORK5CYII=',
			'83C4' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAYUlEQVR4nGNYhQEaGAYTpIn7WANYQxhCHRoCkMREpoi0MjoENCKLBbQyNLo2CLSiqmNoZW1gmBKA5L6lUavClq5aFRWF5D6IOqCJGOYxhoZg2oHNLShi2Nw8UOFHRYjFfQBezs37WcumtAAAAABJRU5ErkJggg==',
			'9393' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAaElEQVR4nGNYhQEaGAYTpIn7WANYQxhCGUIdkMREpoi0Mjo6OgQgiQW0MjS6NgQ0iKCKtbICxQKQ3Ddt6qqwlZlRS7OQ3MfqytDKEAJXB4FA8xzQzBMAijmiiWFzCzY3D1T4URFicR8Ai/zMb3flRl4AAAAASUVORK5CYII=',
			'6E04' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAaElEQVR4nGNYhQEaGAYTpIn7WANEQxmmMDQEIImJTBFpYAhlaEQWC2gRaWB0dGhFEWsQaWBtCJgSgOS+yKipYUtXRUVFIbkvZApIXaADit5WsFhoCJoY0A5sbkERw+bmgQo/KkIs7gMAANTNsOEpKHgAAAAASUVORK5CYII=',
			'111E' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAVklEQVR4nGNYhQEaGAYTpIn7GB0YAhimMIYGIImxOjAGMIQAZZDERB1YAxjRxKB6YWJgJ63MWhW1atrK0Cwk96Gpo1hMNIQ1lDHUEcXNAxV+VIRY3AcAF0jEPSZfi0oAAAAASUVORK5CYII=',
			'1C36' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAZElEQVR4nGNYhQEaGAYTpIn7GB0YQxlDGaY6IImxOrA2ujY6BAQgiYk6iDQ4NAQ6CKDoFWlgaHR0QHbfyqxpq1ZNXZmaheQ+qDoU88BiQPNE0MQcMMSwuCUE080DFX5UhFjcBwDgssprErqCwQAAAABJRU5ErkJggg==',
			'F5EF' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAWElEQVR4nGNYhQEaGAYTpIn7QkNFQ1lDHUNDkMQCGkQaWBsYHRgIi4UgiYGdFBo1denS0JWhWUjuC2hgaHTF0ItNTASLGGsrpr2MIUA3o4gNVPhREWJxHwAbv8p5qthrAQAAAABJRU5ErkJggg==',
			'A5C2' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAc0lEQVR4nGNYhQEaGAYTpIn7GB1EQxlCHaY6IImxBogAxQMCApDERKaINLA2CDqIIIkFtIqEsILkkNwXtXTq0qUgGsl9Aa0Mja4NDI3IdoSGgsVaGVDNA4oJTEEVY20FuQVVjDGEIdQxNGQQhB8VIRb3AQDaNMz51IZjTAAAAABJRU5ErkJggg==',
			'25AB' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAdklEQVR4nGNYhQEaGAYTpIn7WANEQxmmMIY6IImJTBFpYAhldAhAEgtoFWlgdHR0EEHW3SoSwtoQCFMHcdO0qUuXrooMzUJ2XwBDoytCHRgyOgDFQgNRzGNtEAGrQxYTaWBtZUXTGxrKCLIXxc0DFX5UhFjcBwBCscu0UecUsQAAAABJRU5ErkJggg==',
			'CAD3' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAaklEQVR4nGNYhQEaGAYTpIn7WEMYAlhDGUIdkMREWhlDWBsdHQKQxAIaWVtZGwIaRJDFGkQaXYFkAJL7olZNW5m6KmppFpL70NRBxURDXdHNa4SoE0FxC1AMzS2sIUAxNDcPVPhREWJxHwBhsc8PdMUsNgAAAABJRU5ErkJggg==',
			'E8C1' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAWUlEQVR4nGNYhQEaGAYTpIn7QkMYQxhCHVqRxQIaWFsZHQKmooqJNLo2CISiq2NtYIDpBTspNGpl2NJVq5Yiuw9NHZJ52MQEsLkFRQzq5tCAQRB+VIRY3AcAdPPNRhs4rVgAAAAASUVORK5CYII=',
			'CE47' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAaUlEQVR4nGNYhQEaGAYTpIn7WENEQxkaHUNDkMREWkUaGFodGkSQxAIagbypaGIgXqADkEa4L2rV1LCVmVkrs5DcB1LH2ujQyoCmlzU0YAoDuh2NDgEM6G5pdHTA4mYUsYEKPypCLO4DADrRzMt9rY1PAAAAAElFTkSuQmCC',
			'8BBB' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAUUlEQVR4nGNYhQEaGAYTpIn7WANEQ1hDGUMdkMREpoi0sjY6OgQgiQW0ijS6NgQ6iOBWB3bS0qipYUtDV4ZmIbmPWPOIsAOnmwcq/KgIsbgPAOWZzM+vwas5AAAAAElFTkSuQmCC',
			'5321' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAbElEQVR4nGNYhQEaGAYTpIn7QkNYQxhCGVqRxQIaRFoZHR2moooxNLo2BIQiiwUGgPQFwPSCnRQ2bVXYqpVZS1Hc1wqFyDa3MjQ6TEGzFyQWgComMgXoFgdUMdYA1hDW0IDQgEEQflSEWNwHAMMJy7cUnkXIAAAAAElFTkSuQmCC',
			'B419' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAbklEQVR4nGNYhQEaGAYTpIn7QgMYWhmmMEx1QBILAPIZQhgCApDFWhlCGUMYHURQ1DG6MkyBi4GdFBq1dOmqaauiwpDcFzBFBGwHit5W0VCHKQwNqGJgt6DZARZDcQvIzYyhDihuHqjwoyLE4j4AfMbMmmDfn8QAAAAASUVORK5CYII=',
			'A2D2' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAdElEQVR4nM2QMQ7AIAhFceAG9j4s7jSRxdPg0BvYI7h4yupUTDu2ifztQeAFaI9SWCm/+DlyEQVOMgwZD8zEbJgvPgfdyRvGB3TG6o1fqq3Wlnpuvz5XUDnbGyLAODrTPkedlZmhDpeZbRLESVzgfx/mxe8C4cbNu1y0Iw0AAAAASUVORK5CYII=',
			'5A8C' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAbklEQVR4nGNYhQEaGAYTpIn7QkMYAhhCGaYGIIkFNDCGMDo6BIigiLG2sjYEOrAgiQUGiDQ6Ojo6ILsvbNq0lVmhK7NQ3NeKog4qJhrqCjQPWSwAqM4VzQ6RKSC9qG5hBdrrgObmgQo/KkIs7gMAdnTLyko0oQkAAAAASUVORK5CYII=',
			'0859' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAcklEQVR4nGNYhQEaGAYTpIn7GB0YQ1hDHaY6IImxBrC2sjYwBAQgiYlMEWl0BaoWQRILaAWqmwoXAzspaunKsKWZWVFhSO4DqQOSU1H1ijQ6NAQ0iGDYEYBiB8gtjI4OKG4BuZkhlAHFzQMVflSEWNwHABypy2xTPpdJAAAAAElFTkSuQmCC',
			'F623' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAaklEQVR4nGNYhQEaGAYTpIn7QkMZQxhCGUIdkMQCGlhbGR0dHQJQxEQaWUEkqhiYDEByX2jUtLBVK7OWZiG5L6BBtJWhlaEB3TyHKQzo5jU6BKCLAd3iwIjmFsYQ1tAAFDcPVPhREWJxHwDEL81/Y7rswwAAAABJRU5ErkJggg==',
			'C574' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAbklEQVR4nGNYhQEaGAYTpIn7WENEQ1lDAxoCkMREWkWAZEAjslhAI1isFUWsQSSEodFhSgCS+6JWTV26aumqqCgk9wHlgaoYHVD1AsUCGENDUO1odHRgQHMLaytrA6oYawhjCLrYQIUfFSEW9wEAb8bOm0mO8JwAAAAASUVORK5CYII=',
			'6915' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAcUlEQVR4nGNYhQEaGAYTpIn7WAMYQximMIYGIImJTGFtZQhhdEBWF9Ai0uiILtYg0ugwhdHVAcl9kVFLl2ZNWxkVheS+kCmMgQ5TgOYi621laMQUYwGZ5yCC7pYpDAHI7gO5mTHUYarDIAg/KkIs7gMAOezLrJfMQCQAAAAASUVORK5CYII=',
			'948D' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAaklEQVR4nGNYhQEaGAYTpIn7WAMYWhlCGUMdkMREpjBMZXR0dAhAEgsAqmJtCHQQQRFjdAWpE0Fy37SpS5euCl2ZNQ3JfayuIq1I6iCwVTTUFc08gVaGVnQ7gG5pRXcLNjcPVPhREWJxHwCbrcofqnQn5AAAAABJRU5ErkJggg==',
			'B22A' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAeElEQVR4nGNYhQEaGAYTpIn7QgMYQxhCGVqRxQKmsLYyOjpMdUAWaxVpdG0ICAhAUcfQ6NAQ6CCC5L7QqFVLV63MzJqG5D6guikMrYwwdVDzGAIYpjCGhqCIMTowBKCpm8LawOiAKhYaIBrqGhqIIjZQ4UdFiMV9AKk9zESW619TAAAAAElFTkSuQmCC',
			'D9EE' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAVklEQVR4nGNYhQEaGAYTpIn7QgMYQ1hDHUMDkMQCprC2sjYwOiCrC2gVaXTFLwZ2UtTSpUtTQ1eGZiG5L6CVMRBTLwMW81gwxbC4BZubByr8qAixuA8AM5rLW8iKjh8AAAAASUVORK5CYII=',
			'1ABA' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAaUlEQVR4nGNYhQEaGAYTpIn7GB0YAlhDGVqRxVgdGENYGx2mOiCJiTqwtrI2BAQEoOgVaXRtdHQQQXLfyqxpK1NDgSSS+9DUQcVEQ10bAkND0M1rCERTh6lXNAQoFsqIIjZQ4UdFiMV9AGUyyiNYvitqAAAAAElFTkSuQmCC',
			'5FE3' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAXElEQVR4nGNYhQEaGAYTpIn7QkNEQ11DHUIdkMQCGkQaWBsYHQIwxBiAJEIsMAAiFoDkvrBpU8OWhq5amoXsvlYUdShiyOYFYBETmYLpFlaQvWhuHqjwoyLE4j4AoqPMZLhhixQAAAAASUVORK5CYII=',
			'CD18' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAZklEQVR4nGNYhQEaGAYTpIn7WENEQximMEx1QBITaRVpZQhhCAhAEgtoFGl0DGF0EEEWaxBpdJgCVwd2UtSqaSuzpq2amoXkPjR1SGJo5jViioHdgqYX5GbGUAcUNw9U+FERYnEfAGFgzToMJcG6AAAAAElFTkSuQmCC',
			'8B54' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAaklEQVR4nGNYhQEaGAYTpIn7WANEQ1hDHRoCkMREpoi0sjYwNCKLBbSKNLo2MLRiqJvKMCUAyX1Lo6aGLc3MiopCch9IHUNDoAO6eQ4NgaEhGHYEYLiF0RHVfSA3M4QyoIgNVPhREWJxHwDpBc5utHiWOAAAAABJRU5ErkJggg==',
			'8B93' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAY0lEQVR4nGNYhQEaGAYTpIn7WANEQxhCGUIdkMREpoi0Mjo6OgQgiQW0ijS6NgQ0iKCpYwWKBSC5b2nU1LCVmVFLs5DcB1LHEAJXBzfPAc08kJgjFjvQ3YLNzQMVflSEWNwHALH2zXMHm1C0AAAAAElFTkSuQmCC',
			'76BE' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAYUlEQVR4nGNYhQEaGAYTpIn7QkMZQ1hDGUMDkEVbWVtZGx0dUFS2ijSyNgSiik0RaUBSB3FT1LSwpaErQ7OQ3MfoIIphHmuDSKMrmnkiWMQCGjDdEtCAxc0DFH5UhFjcBwC9Scpo/ck9pQAAAABJRU5ErkJggg==',
			'4BCE' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAY0lEQVR4nGNYhQEaGAYTpI37poiGMIQ6hgYgi4WItDI6BDogq2MMEWl0bRBEEWOdItLK2sAIEwM7adq0qWFLV60MzUJyXwCqOjAMDQWZhyrGMAXTDqAYhluwunmgwo96EIv7AFejygaG3moIAAAAAElFTkSuQmCC',
			'142E' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAbklEQVR4nGNYhQEaGAYTpIn7GB0YWhlCGUMDkMRYHRimMjo6OiCrE3VgCGVtCHRA1cvoyoAQAztpZdbSpatWZoZmIbmP0UGklaGVEU2vaKjDFHQxoFsCMMWA9qC6JYShlTU0EMXNAxV+VIRY3AcAi4XGFpKgPyYAAAAASUVORK5CYII=',
			'9362' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAa0lEQVR4nGNYhQEaGAYTpIn7WANYQxhCGaY6IImJTBFpZXR0CAhAEgtoZWh0bXB0EEEVa2UFqUdy37Spq8KWTl21KgrJfayuQHWODo3IdjCAzQOagCQmABGbwoDFLZhuZgwNGQThR0WIxX0A/GfL8chV4JMAAAAASUVORK5CYII=',
			'E312' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAaElEQVR4nGNYhQEaGAYTpIn7QkNYQximMEx1QBILaBBpZQhhCAhAEWNodAxhdBBBFWsF6m0QQXJfaNSqsFXTVq2KQnIfVF2jA5p5DlOA4phiUxjQ3TKFIQDdzYyhjqEhgyD8qAixuA8AKeLNBEAxpJgAAAAASUVORK5CYII=',
			'EE31' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAUklEQVR4nGNYhQEaGAYTpIn7QkNEQxlDGVqRxQIaRBpYGx2moosByVAMsUYHmF6wk0KjpoatmrpqKbL70NQhm0eUGCuaXqibQwMGQfhREWJxHwAqos3W9QDlhQAAAABJRU5ErkJggg==',
			'95B6' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAcklEQVR4nGNYhQEaGAYTpIn7WANEQ1lDGaY6IImJTBFpYG10CAhAEgtoBYo1BDoIoIqFsDY6OiC7b9rUqUuXhq5MzUJyH6srQ6NroyOKeQytQDGgeSJIYgKtIhhiIlNYW9HdwhrAGILu5oEKPypCLO4DAHgtzGzrAVZQAAAAAElFTkSuQmCC',
			'AC37' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAaklEQVR4nGNYhQEaGAYTpIn7GB0YQ0EwBEmMNYC10bXRoUEESUxkikiDQ0MAilhAK5DXCBJFuC9q6bRVq6auWpmF5D6oulZke0NDQSYFTGFAMw9oWgCqGMgtjg6oYmA3o4gNVPhREWJxHwBK3M3qZIyB6gAAAABJRU5ErkJggg==',
			'0EB9' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAZElEQVR4nGNYhQEaGAYTpIn7GB1EQ1lDGaY6IImxBog0sDY6BAQgiYlMAYo1BDqIIIkFtILUOcLEwE6KWjo1bGnoqqgwJPdB1DlMxdDbENAggmFHAIod2NyCzc0DFX5UhFjcBwCicsvUuvFRYwAAAABJRU5ErkJggg==',
			'4D4E' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAZ0lEQVR4nGNYhQEaGAYTpI37poiGMDQ6hgYgi4WItDK0Ojogq2MMEWl0mIoqxjoFKBYIFwM7adq0aSszMzNDs5DcFwBU59qIqjc0FCgWGuiA6hageWjqgGKtDBhiWNw8UOFHPYjFfQBpcsuva9yEoQAAAABJRU5ErkJggg==',
			'C61A' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAb0lEQVR4nGNYhQEaGAYTpIn7WEMYQximMLQii4m0srYyhDBMdUASC2gUaQSqDAhAFmsQaWCYwuggguS+qFXTwlZNW5k1Dcl9AQ2irUjqYHobHaYwhoag2eGApg7sFjQxkJsZQx1RxAYq/KgIsbgPABZsy0n26lFCAAAAAElFTkSuQmCC',
			'F994' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAZklEQVR4nGNYhQEaGAYTpIn7QkMZQxhCGRoCkMQCGlhbGR0dGlHFRBpdGwJasYhNCUByX2jU0qWZmVFRUUjuC2hgDHQICXRA1cvQ6NAQGBqCIsbS6AgksbgFTQzTzQMVflSEWNwHAC9iz3DzG52PAAAAAElFTkSuQmCC',
			'2880' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAZklEQVR4nGNYhQEaGAYTpIn7WAMYQxhCGVqRxUSmsLYyOjpMdUASC2gVaXRtCAgIQNbdClLn6CCC7L5pK8NWha7MmobsvgAUdWDI6AAyLxBFjLUB0w6RBky3hIZiunmgwo+KEIv7AAeLy1KJb+CoAAAAAElFTkSuQmCC',
			'124B' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAcElEQVR4nGNYhQEaGAYTpIn7GB0YQxgaHUMdkMRYHVhbGVodHQKQxEQdRBodpjo6iKDoZWh0CISrAztpZdaqpSszM0OzkNwHVDeFtRHVPKBYAGtoIJp5IBPR7WBtYEDTKxoiGuqA5uaBCj8qQizuAwCLdclHSq2HLAAAAABJRU5ErkJggg==',
			'6733' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAcUlEQVR4nGNYhQEaGAYTpIn7WANEQx1DGUIdkMREpjA0ujY6OgQgiQW0MDQ6NAQ0iCCLNTC0QkQR7ouMWjVt1dRVS7OQ3BcyhSEASR1EbyujAwO6ea2sDehiIlNEGljR3MIaINLAiObmgQo/KkIs7gMAxhHOJyHDM7sAAAAASUVORK5CYII=',
			'D904' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAZ0lEQVR4nGNYhQEaGAYTpIn7QgMYQximMDQEIIkFTGFtZQhlaEQRaxVpdHR0aEUXcwWqDkByX9TSpUtTV0VFRSG5L6CVMdC1IdABVS8DUG9gaAiKGAvIDmxuQRHD5uaBCj8qQizuAwCsHs/GLVsaiQAAAABJRU5ErkJggg==',
			'5669' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAcElEQVR4nGNYhQEaGAYTpIn7QkMYQxhCGaY6IIkFNLC2Mjo6BASgiIk0sjY4OoggiQUGiDSwNjDCxMBOCps2LWzp1FVRYcjuaxVtZXV0mIqsl6FVpNEVZCqyHRAxFDtEpmC6hTUA080DFX5UhFjcBwDiJMv1+9qIJAAAAABJRU5ErkJggg==',
			'1121' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAYklEQVR4nGNYhQEaGAYTpIn7GB0YAhhCGVqRxVgdGAMYHR2mIouJOrAGsDYEhGLobQiA6QU7aWXWqiggsRTZfWB1rah2gMWmYBELwBQDYhQx0RDWUNbQgNCAQRB+VIRY3AcA0hnGVNfNo00AAAAASUVORK5CYII=',
			'D4F2' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAb0lEQVR4nGNYhQEaGAYTpIn7QgMYWllDA6Y6IIkFTGGYytrAEBCALNbKEMrawOgggiLG6ApU1yCC5L6opUAQCqSR3BfQKtIKVNeIYkeraKhrA0MrA6odIHVTGFDdAhILwHBzA2NoyCAIPypCLO4DAE4OzQLlVZClAAAAAElFTkSuQmCC',
			'395E' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAaklEQVR4nGNYhQEaGAYTpIn7RAMYQ1hDHUMDkMQCprC2sjYwOqCobBVpdEUXmwIUmwoXAztpZdTSpamZmaFZyO6bwhjo0BCIZh5DI6YYC9AOVDGQWxgdHVHEQG5mCGVEcfNAhR8VIRb3AQBs1cn0mLDY2wAAAABJRU5ErkJggg==',
			'5D61' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAZUlEQVR4nGNYhQEaGAYTpIn7QkNEQxhCGVqRxQIaRFoZHR2mook1ujY4hCKLBQaAxOB6wU4KmzZtZerUVUtR3NcKVOfogGIHWKwhANVeLGIiU8BuQRFjDQC7OTRgEIQfFSEW9wEAf6HNMf5u26UAAAAASUVORK5CYII=',
			'218D' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAZklEQVR4nGNYhQEaGAYTpIn7WAMYAhhCGUMdkMREpjAGMDo6OgQgiQW0sgawNgQ6iCDrbmUAqxNBdt+0VVGrQldmTUN2XwCKOjBkdGDAMI+1AVMMyMZwS2goayi6mwcq/KgIsbgPAM8cx+qg+lBxAAAAAElFTkSuQmCC',
			'D527' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAdElEQVR4nM2QwQ2AMAgA4dEN6j64ASbl4whOgQ82qCP0oVPan0V9apRLeFxCcgG2yyj8iVf6hDsBQUmN4xwVe9LYOosalM8u1V05+saylG2d1qnpY4OZDAzcbXUZsndxJgZ2LgdDQvLNmIIMzn31vwe56dsBswTNHN2HcN0AAAAASUVORK5CYII=',
			'43D5' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAbklEQVR4nGNYhQEaGAYTpI37prCGsIYyhgYgi4WItLI2Ojogq2MMYWh0bQhEEWOdwtDK2hDo6oDkvmnTVoUtXRUZFYXkvgCwuoAGESS9oaEg81DFGKZA7EAVA7nFIQDFfWA3M0x1GAzhRz2IxX0AyI3MLS4TO+sAAAAASUVORK5CYII=',
			'9BBE' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAWElEQVR4nGNYhQEaGAYTpIn7WANEQ1hDGUMDkMREpoi0sjY6OiCrC2gVaXRtCEQXQ1YHdtK0qVPDloauDM1Cch+rK6Z5DFjME8Aihs0t2Nw8UOFHRYjFfQCYHMreUbgPiAAAAABJRU5ErkJggg==',
			'7249' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAcklEQVR4nGNYhQEaGAYTpIn7QkMZQxgaHaY6IIu2srYytDoEBKCIiQBVOTqIIItNAeoMhItB3BS1aunKzKyoMCT3MTowTGEF6kbWy9rAEMAaGtCALCYCUtnogGJHAEhlI6pbAhpEQx3Q3TxA4UdFiMV9AI9UzJlMlFc9AAAAAElFTkSuQmCC',
			'BB99' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAZUlEQVR4nGNYhQEaGAYTpIn7QgNEQxhCGaY6IIkFTBFpZXR0CAhAFmsVaXRtCHQQQVPHihADOyk0amrYysyoqDAk94HUMYQETBVBM8+hIaABXcyxIQDDDnS3YHPzQIUfFSEW9wEAIN/N0f+OSzQAAAAASUVORK5CYII=',
			'03F7' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAYklEQVR4nGNYhQEaGAYTpIn7GB1YQ1hDA0NDkMRYA0RaWYG0CJKYyBSGRlc0sYBWBrC6ACT3RS1dFbY0dNXKLCT3QdW1MqDqBZk3hQHTjgBkMYhbGB0w3IwmNlDhR0WIxX0AdAfKjNRxbvIAAAAASUVORK5CYII=',
			'AD9C' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAZ0lEQVR4nGNYhQEaGAYTpIn7GB1EQxhCGaYGIImxBoi0Mjo6BIggiYlMEWl0bQh0YEESC2iFiCG7L2rptJWZmZFZyO4DqXMIgasDw9BQoFgDqhhInSOmHRhuCWjFdPNAhR8VIRb3AQA5XcyCRbf3FAAAAABJRU5ErkJggg==',
			'84F8' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAaUlEQVR4nGNYhQEaGAYTpIn7WAMYWllDA6Y6IImJTGGYytrAEBCAJBbQyhDK2sDoIIKijtEVSR3YSUujli5dGrpqahaS+0SmiLRimica6opmHtCOVkw7GDD0gt3cwIDi5oEKPypCLO4DAFOsy4KMSE+gAAAAAElFTkSuQmCC',
			'E977' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAaElEQVR4nGNYhQEaGAYTpIn7QkMYQ1hDA0NDkMQCGlhbQaQIiphIowM2MbAown2hUUuXZi1dtTILyX0BDYyBDlMYWhlQ9DI0OgQwTEEVY2l0dGAIYEBzC2sDowOGm9HEBir8qAixuA8AQ53NWeMWJVUAAAAASUVORK5CYII=',
			'E699' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAZElEQVR4nGNYhQEaGAYTpIn7QkMYQxhCGaY6IIkFNLC2Mjo6BASgiIk0sjYEOoigijUgiYGdFBo1LWxlZlRUGJL7AhpEWxlCAqai6W10AJuAKubYEIBmB6ZbsLl5oMKPihCL+wD5H8zxIqFrYAAAAABJRU5ErkJggg==',
			'F6B0' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAYUlEQVR4nGNYhQEaGAYTpIn7QkMZQ1hDGVqRxQIaWFtZGx2mOqCIiTSyNgQEBKCKNbA2OjqIILkvNGpa2NLQlVnTkNwX0CDaiqQObp5rQyAWMXQ7sLkF080DFX5UhFjcBwBr9c4c32qGBAAAAABJRU5ErkJggg==',
			'81F7' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAX0lEQVR4nGNYhQEaGAYTpIn7WAMYAlhDA0NDkMREpjAGsIJoJLGAVlYMMZEpDGCxACT3LY1aFbU0dNXKLCT3QdW1MqCYBxabgkUsgAHDDkYHVDezhqKLDVT4URFicR8AmcrJDT+hp3sAAAAASUVORK5CYII=',
			'3CD6' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAXklEQVR4nGNYhQEaGAYTpIn7RAMYQ1lDGaY6IIkFTGFtdG10CAhAVtkq0uDaEOgggCw2RaSBFSiG7L6VUdNWLV0VmZqF7D6IOgzzQHpFsNghQsAt2Nw8UOFHRYjFfQBKDs0a3nWKBAAAAABJRU5ErkJggg==',
			'C41E' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAZ0lEQVR4nGNYhQEaGAYTpIn7WEMYWhmmMIYGIImJtDJMZQhhdEBWF9DIEMqILtbA6ArUCxMDOylq1dKlq6atDM1Ccl8AyMQp6HpFQx3QxRoZMNQBdWKIgdzMGOqI4uaBCj8qQizuAwC208mIcP/AAwAAAABJRU5ErkJggg==',
			'760C' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAaUlEQVR4nGNYhQEaGAYTpIn7QkMZQximMEwNQBZtZW1lCGUIEEERE2lkdHR0YEEWmyLSwNoQ6IDivqhpYUtXRWYhu4/RQbQVSR0YsjaINLqiiYkAxRzR7AhowHRLQAMWNw9Q+FERYnEfAPvHypi6YQGpAAAAAElFTkSuQmCC',
			'4060' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAbklEQVR4nGNYhQEaGAYTpI37pjAEMIQytKKIhTCGMDo6THVAEmMMYW1lbXAICEASY50i0ujawOggguS+adOmrUydujJrGpL7AkDqHB1h6sAwNBSkNxBFjGEKyI4AFDsYpmC6BaubByr8qAexuA8ADq/LcT6OkAsAAAAASUVORK5CYII=',
			'039F' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAY0lEQVR4nGNYhQEaGAYTpIn7GB1YQxhCGUNDkMRYA0RaGR0dHZDViUxhaHRtCEQRC2hlaGVFiIGdFLV0VdjKzMjQLCT3gdQxhGDobXRAMw9khyOaGDa3QN2MIjZQ4UdFiMV9ADnhyO9WCubKAAAAAElFTkSuQmCC',
			'C69C' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAZklEQVR4nGNYhQEaGAYTpIn7WEMYQxhCGaYGIImJtLK2Mjo6BIggiQU0ijSyNgQ6sCCLNYg0gMSQ3Re1alrYyszILGT3BTSItjKEwNXB9DY6NKCJAe1wRLMDm1uwuXmgwo+KEIv7AArTy1fMzIogAAAAAElFTkSuQmCC',
			'8434' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAbklEQVR4nGNYhQEaGAYTpIn7WAMYWhlDGRoCkMREpjBMZW10aEQWC2hlAKlqRVXH6MrQ6DAlAMl9S6OWLl01dVVUFJL7RKaItDI0Ojqgmica6tAQGBqCakcryCVobmkFugVFDJubByr8qAixuA8AMxPOsFbrv40AAAAASUVORK5CYII=',
			'C728' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAdklEQVR4nGNYhQEaGAYTpIn7WENEQx1CGaY6IImJtDI0Ojo6BAQgiQU0MjS6NgQ6iCCLNTC0AkmYOrCTolatmrZqZdbULCT3AeUDgCpRzWtgdGCYwohqXiMrUCWqmEirCEglil7WEJEG1tAAFDcPVPhREWJxHwBsFcwpyTztNQAAAABJRU5ErkJggg==',
			'EEAA' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAWklEQVR4nGNYhQEaGAYTpIn7QkNEQxmmMLQiiwU0iDQwhDJMdUATY3R0CAhAE2NtCHQQQXJfaNTUsKWrIrOmIbkPTR1CLDQwNAS3eTjFQG5GFxuo8KMixOI+ABoizPoh1VfxAAAAAElFTkSuQmCC',
			'28A7' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAdElEQVR4nGNYhQEaGAYTpIn7WAMYQximMIaGIImJTGFtZQgF0khiAa0ijY6ODihiDK2srawNAUCI5L5pK8OWropamYXsvgCwulZkexkdRBpdQwOmoLilASjWEBCALCbSANIb6IAsFhrKGIIuNlDhR0WIxX0AAnHMDRpiGdYAAAAASUVORK5CYII=',
			'3B37' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAX0lEQVR4nGNYhQEaGAYTpIn7RANEQxhDGUNDkMQCpoi0sjY6NIggq2wVAYoEoIoB1TGARRHuWxk1NWzV1FUrs5DdB1HXyoBp3hQsYgEMGG5xdMDiZhSxgQo/KkIs7gMAXJTM6pIsWoIAAAAASUVORK5CYII=',
			'889D' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAYUlEQVR4nGNYhQEaGAYTpIn7WAMYQxhCGUMdkMREprC2Mjo6OgQgiQW0ijS6NgQ6iKCpY0WIgZ20NGpl2MrMyKxpSO4DqWMIQdULMs+hAVPMEYsd6G7B5uaBCj8qQizuAwAeT8ti2QB15QAAAABJRU5ErkJggg==',
			'8E6D' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAXklEQVR4nGNYhQEaGAYTpIn7WANEQxlCGUMdkMREpog0MDo6OgQgiQW0ijSwNjg6iKCpY21ghImBnbQ0amrY0qkrs6YhuQ+szhFVL8S8QIJi2NyCzc0DFX5UhFjcBwB8DsrgPsJGTwAAAABJRU5ErkJggg==',
			'F2D8' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAZ0lEQVR4nGNYhQEaGAYTpIn7QkMZQ1hDGaY6IIkFNLC2sjY6BASgiIk0ujYEOoigiDEAxQJg6sBOCo1atXTpqqipWUjuA8pPYUWog4kFsGKYx+iAKcbagOkW0VBXNDcPVPhREWJxHwAIKc523J7c8gAAAABJRU5ErkJggg==',
			'846F' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAaklEQVR4nGNYhQEaGAYTpIn7WAMYWhlCGUNDkMREpjBMZXR0dEBWFwBUxdqAKiYyhdGVtYERJgZ20tKopUuXTl0ZmoXkPpEpIq2sGOaJhro2BKLb0cqKJgZ0Syu6W6BuRhEbqPCjIsTiPgC3HMlgXytHDgAAAABJRU5ErkJggg==',
			'5714' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAbklEQVR4nM2QsQ2AMAwEPwUbhH3MBkZKKDJNUngDiyEyJaEzCSUI/I11kuXTow6T8ae84hfDHEmR2bC2FwooPVsCxLKVIVAoG79tr2dSsn4ChjqytxBHjcVgf8iU0bl49QOb2GcX6cK+6u/B3PgdEgzNhuHDOH8AAAAASUVORK5CYII=',
			'451A' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAcElEQVR4nGNYhQEaGAYTpI37poiGMkxhaEURCxEBYoapDkhijEAxxhCGgAAkMdYpIiEMUxgdRJDcN23a1KWrpq3MmobkvoApDI0OCHVgGBoKFgsNQXGLCIY6himsrQwYYowhjKGOqGIDFX7Ug1jcBwCLYsrucRaaRQAAAABJRU5ErkJggg==',
			'7B12' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAcElEQVR4nGNYhQEaGAYTpIn7QkNFQximMEx1QBZtFWllCGEICEAVa3QMYXQQQRabAlQ3haFBBNl9UVPDVk0DUkjuA+oCqWtEtoO1QaTRYQpDK7JbRCBiU5DFAhrAegNQxURDGEMdQ0MGQfhREWJxHwDOL8wIrvgagQAAAABJRU5ErkJggg==',
			'664F' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAaElEQVR4nGNYhQEaGAYTpIn7WAMYQxgaHUNDkMREprC2MrQ6OiCrC2gRaWSYiibWINLAEAgXAzspMmpa2MrMzNAsJPeFTBFtZW1E09sq0ugaGogh5oCmDuwWNDGom1HEBir8qAixuA8AglnK0Akj5qMAAAAASUVORK5CYII=',
			'3610' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAaElEQVR4nGNYhQEaGAYTpIn7RAMYQximMLQiiwVMYW1lCGGY6oCsslWkEagyIABZbIoIEDM6iCC5b2XUtLBV01ZmTUN23xTRViR1cPMcsIqh2gF2yxRUt4DczBjqgOLmgQo/KkIs7gMA0yHLQVkf/AgAAAAASUVORK5CYII=',
			'E738' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAZUlEQVR4nGNYhQEaGAYTpIn7QkNEQx1DGaY6IIkFNDA0ujY6BASgiTk0BDqIoIq1MiDUgZ0UGrVq2qqpq6ZmIbkPKB/AgGEeowMDhnmsDZhiIg2saHpDQ0QaGNHcPFDhR0WIxX0AHprOZrwuSgcAAAAASUVORK5CYII=',
			'B700' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAaUlEQVR4nGNYhQEaGAYTpIn7QgNEQx2mMLQiiwVMYWh0CGWY6oAs1srQ6OjoEBCAqq6VtSHQQQTJfaFRq6YtXRWZNQ3JfUB1AUjqoOYxOmCKsTYwYtgBVIHmltAAoBiamwcq/KgIsbgPAOsTzXIGnJb/AAAAAElFTkSuQmCC',
			'1E70' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAZklEQVR4nGNYhQEaGAYTpIn7GB1EQ1lDA1qRxVgdRIBkwFQHJDFRiFhAAIpeoFijI1gG5r6VWVPDVi1dmTUNyX1gdVMYYeoQYgGYYowODBh2sDYwoLolBOjmBgYUNw9U+FERYnEfADwGyNdF7VwnAAAAAElFTkSuQmCC',
			'D3D0' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAW0lEQVR4nGNYhQEaGAYTpIn7QgNYQ1hDGVqRxQKmiLSyNjpMdUAWa2VodG0ICAhAFWtlbQh0EEFyX9TSVWFLV0VmTUNyH5o6JPOwiaHZgcUt2Nw8UOFHRYjFfQBSxc66EjkngwAAAABJRU5ErkJggg==',
			'C4BD' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAaUlEQVR4nGNYhQEaGAYTpIn7WEMYWllDGUMdkMREWhmmsjY6OgQgiQU0MoSyNgQ6iCCLNTC6gtSJILkvatXSpUtDV2ZNQ3JfANBEJHVQMdFQV3TzGoFuQRMDuqUV3S3Y3DxQ4UdFiMV9ANk7y/uJuYPwAAAAAElFTkSuQmCC',
			'BACE' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAZklEQVR4nGNYhQEaGAYTpIn7QgMYAhhCHUMDkMQCpjCGMDoEOiCrC2hlbWVtEEQVmyLS6NrACBMDOyk0atrK1FUrQ7OQ3IemDmqeaCimGEgdph2OaG4JDRBpdEBz80CFHxUhFvcBAMmUzCOGplHHAAAAAElFTkSuQmCC',
			'F16D' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAW0lEQVR4nGNYhQEaGAYTpIn7QkMZAhhCGUMdkMQCGhgDGB0dHQJQxFgDWBscHURQxBiAYowwMbCTQqNWRS2dujJrGpL7wOocsekNJEoMi1tC0d08UOFHRYjFfQBnCMoK98ksigAAAABJRU5ErkJggg==',
			'CCCB' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAXklEQVR4nGNYhQEaGAYTpIn7WEMYQxlCHUMdkMREWlkbHR0CHQKQxAIaRRpcGwQdRJDFGkQaWBsYYerATopaNW3V0lUrQ7OQ3IemDkVMhIAd2NyCzc0DFX5UhFjcBwBZ9MxMUqLPlwAAAABJRU5ErkJggg==',
			'43DD' => 'iVBORw0KGgoAAAANSUhEUgAAAEkAAAAhAgMAAADoum54AAAACVBMVEX///8AAADS0tIrj1xmAAAAYElEQVR4nGNYhQEaGAYTpI37prCGsIYyhjogi4WItLI2OjoEIIkxhjA0ujYEOoggibFOYWhlRYiBnTRt2qqwpasis6YhuS8AVR0YhoZimscwBZsYpluwunmgwo96EIv7AIp+y9CB+rQWAAAAAElFTkSuQmCC'        
        );
        $this->text = array_rand( $images );
        return $images[ $this->text ] ;    
    }
    
    function out_processing_gif(){
        $image = dirname(__FILE__) . '/processing.gif';
        $base64_image = "R0lGODlhFAAUALMIAPh2AP+TMsZiALlcAKNOAOp4ANVqAP+PFv///wAAAAAAAAAAAAAAAAAAAAAAAAAAACH/C05FVFNDQVBFMi4wAwEAAAAh+QQFCgAIACwAAAAAFAAUAAAEUxDJSau9iBDMtebTMEjehgTBJYqkiaLWOlZvGs8WDO6UIPCHw8TnAwWDEuKPcxQml0Ynj2cwYACAS7VqwWItWyuiUJB4s2AxmWxGg9bl6YQtl0cAACH5BAUKAAgALAEAAQASABIAAAROEMkpx6A4W5upENUmEQT2feFIltMJYivbvhnZ3Z1h4FMQIDodz+cL7nDEn5CH8DGZhcLtcMBEoxkqlXKVIgAAibbK9YLBYvLtHH5K0J0IACH5BAUKAAgALAEAAQASABIAAAROEMkphaA4W5upMdUmDQP2feFIltMJYivbvhnZ3V1R4BNBIDodz+cL7nDEn5CH8DGZAMAtEMBEoxkqlXKVIg4HibbK9YLBYvLtHH5K0J0IACH5BAUKAAgALAEAAQASABIAAAROEMkpjaE4W5tpKdUmCQL2feFIltMJYivbvhnZ3R0A4NMwIDodz+cL7nDEn5CH8DGZh8ONQMBEoxkqlXKVIgIBibbK9YLBYvLtHH5K0J0IACH5BAUKAAgALAEAAQASABIAAAROEMkpS6E4W5spANUmGQb2feFIltMJYivbvhnZ3d1x4JMgIDodz+cL7nDEn5CH8DGZgcBtMMBEoxkqlXKVIggEibbK9YLBYvLtHH5K0J0IACH5BAUKAAgALAEAAQASABIAAAROEMkpAaA4W5vpOdUmFQX2feFIltMJYivbvhnZ3V0Q4JNhIDodz+cL7nDEn5CH8DGZBMJNIMBEoxkqlXKVIgYDibbK9YLBYvLtHH5K0J0IACH5BAUKAAgALAEAAQASABIAAAROEMkpz6E4W5tpCNUmAQD2feFIltMJYivbvhnZ3R1B4FNRIDodz+cL7nDEn5CH8DGZg8HNYMBEoxkqlXKVIgQCibbK9YLBYvLtHH5K0J0IACH5BAkKAAgALAEAAQASABIAAAROEMkpQ6A4W5spIdUmHQf2feFIltMJYivbvhnZ3d0w4BMAIDodz+cL7nDEn5CH8DGZAsGtUMBEoxkqlXKVIgwGibbK9YLBYvLtHH5K0J0IADs=";
        $binary = is_file($image) ? join("",file($image)) : base64_decode($base64_image); 
        header("Cache-Control: post-check=0, pre-check=0, max-age=0, no-store, no-cache, must-revalidate");
        header("Pragma: no-cache");
        header("Content-type: image/gif");
        echo $binary;
    }

}
# end of class phpfmgImage
# ------------------------------------------------------
# end of module : captcha


# module user
# ------------------------------------------------------
function phpfmg_user_isLogin(){
    return ( isset($_SESSION['authenticated']) && true === $_SESSION['authenticated'] );
}


function phpfmg_user_logout(){
    session_destroy();
    header("Location: admin.php");
}

function phpfmg_user_login()
{
    if( phpfmg_user_isLogin() ){
        return true ;
    };
    
    $sErr = "" ;
    if( 'Y' == $_POST['formmail_submit'] ){
        if(
            defined( 'PHPFMG_USER' ) && strtolower(PHPFMG_USER) == strtolower($_POST['Username']) &&
            defined( 'PHPFMG_PW' )   && strtolower(PHPFMG_PW) == strtolower($_POST['Password']) 
        ){
             $_SESSION['authenticated'] = true ;
             return true ;
             
        }else{
            $sErr = 'Login failed. Please try again.';
        }
    };
    
    // show login form 
    phpfmg_admin_header();
?>
<form name="frmFormMail" action="" method='post' enctype='multipart/form-data'>
<input type='hidden' name='formmail_submit' value='Y'>
<br><br><br>

<center>
<div style="width:380px;height:260px;">
<fieldset style="padding:18px;" >
<table cellspacing='3' cellpadding='3' border='0' >
	<tr>
		<td class="form_field" valign='top' align='right'>Email :</td>
		<td class="form_text">
            <input type="text" name="Username"  value="<?php echo $_POST['Username']; ?>" class='text_box' >
		</td>
	</tr>

	<tr>
		<td class="form_field" valign='top' align='right'>Password :</td>
		<td class="form_text">
            <input type="password" name="Password"  value="" class='text_box'>
		</td>
	</tr>

	<tr><td colspan=3 align='center'>
        <input type='submit' value='Login'><br><br>
        <?php if( $sErr ) echo "<span style='color:red;font-weight:bold;'>{$sErr}</span><br><br>\n"; ?>
        <a href="admin.php?mod=mail&func=request_password">I forgot my password</a>   
    </td></tr>
</table>
</fieldset>
</div>
<script type="text/javascript">
    document.frmFormMail.Username.focus();
</script>
</form>
<?php
    phpfmg_admin_footer();
}


function phpfmg_mail_request_password(){
    $sErr = '';
    if( $_POST['formmail_submit'] == 'Y' ){
        if( strtoupper(trim($_POST['Username'])) == strtoupper(trim(PHPFMG_USER)) ){
            phpfmg_mail_password();
            exit;
        }else{
            $sErr = "Failed to verify your email.";
        };
    };
    
    $n1 = strpos(PHPFMG_USER,'@');
    $n2 = strrpos(PHPFMG_USER,'.');
    $email = substr(PHPFMG_USER,0,1) . str_repeat('*',$n1-1) . 
            '@' . substr(PHPFMG_USER,$n1+1,1) . str_repeat('*',$n2-$n1-2) . 
            '.' . substr(PHPFMG_USER,$n2+1,1) . str_repeat('*',strlen(PHPFMG_USER)-$n2-2) ;


    phpfmg_admin_header("Request Password of Email Form Admin Panel");
?>
<form name="frmRequestPassword" action="admin.php?mod=mail&func=request_password" method='post' enctype='multipart/form-data'>
<input type='hidden' name='formmail_submit' value='Y'>
<br><br><br>

<center>
<div style="width:580px;height:260px;text-align:left;">
<fieldset style="padding:18px;" >
<legend>Request Password</legend>
Enter Email Address <b><?php echo strtoupper($email) ;?></b>:<br />
<input type="text" name="Username"  value="<?php echo $_POST['Username']; ?>" style="width:380px;">
<input type='submit' value='Verify'><br>
The password will be sent to this email address. 
<?php if( $sErr ) echo "<br /><br /><span style='color:red;font-weight:bold;'>{$sErr}</span><br><br>\n"; ?>
</fieldset>
</div>
<script type="text/javascript">
    document.frmRequestPassword.Username.focus();
</script>
</form>
<?php
    phpfmg_admin_footer();    
}


function phpfmg_mail_password(){
    phpfmg_admin_header();
    if( defined( 'PHPFMG_USER' ) && defined( 'PHPFMG_PW' ) ){
        $body = "Here is the password for your form admin panel:\n\nUsername: " . PHPFMG_USER . "\nPassword: " . PHPFMG_PW . "\n\n" ;
        if( 'html' == PHPFMG_MAIL_TYPE )
            $body = nl2br($body);
        mailAttachments( PHPFMG_USER, "Password for Your Form Admin Panel", $body, PHPFMG_USER, 'You', "You <" . PHPFMG_USER . ">" );
        echo "<center>Your password has been sent.<br><br><a href='admin.php'>Click here to login again</a></center>";
    };   
    phpfmg_admin_footer();
}


function phpfmg_writable_check(){
 
    if( is_writable( dirname(PHPFMG_SAVE_FILE) ) && is_writable( dirname(PHPFMG_EMAILS_LOGFILE) )  ){
        return ;
    };
?>
<style type="text/css">
    .fmg_warning{
        background-color: #F4F6E5;
        border: 1px dashed #ff0000;
        padding: 16px;
        color : black;
        margin: 10px;
        line-height: 180%;
        width:80%;
    }
    
    .fmg_warning_title{
        font-weight: bold;
    }

</style>
<br><br>
<div class="fmg_warning">
    <div class="fmg_warning_title">Your form data or email traffic log is NOT saving.</div>
    The form data (<?php echo PHPFMG_SAVE_FILE ?>) and email traffic log (<?php echo PHPFMG_EMAILS_LOGFILE?>) will be created automatically when the form is submitted. 
    However, the script doesn't have writable permission to create those files. In order to save your valuable information, please set the directory to writable.
     If you don't know how to do it, please ask for help from your web Administrator or Technical Support of your hosting company.   
</div>
<br><br>
<?php
}


function phpfmg_log_view(){
    $n = isset($_REQUEST['file'])  ? $_REQUEST['file']  : '';
    $files = array(
        1 => PHPFMG_EMAILS_LOGFILE,
        2 => PHPFMG_SAVE_FILE,
    );
    
    phpfmg_admin_header();
   
    $file = $files[$n];
    if( is_file($file) ){
        if( 1== $n ){
            echo "<pre>\n";
            echo join("",file($file) );
            echo "</pre>\n";
        }else{
            $man = new phpfmgDataManager();
            $man->displayRecords();
        };
     

    }else{
        echo "<b>No form data found.</b>";
    };
    phpfmg_admin_footer();
}


function phpfmg_log_download(){
    $n = isset($_REQUEST['file'])  ? $_REQUEST['file']  : '';
    $files = array(
        1 => PHPFMG_EMAILS_LOGFILE,
        2 => PHPFMG_SAVE_FILE,
    );

    $file = $files[$n];
    if( is_file($file) ){
        phpfmg_util_download( $file, PHPFMG_SAVE_FILE == $file ? 'form-data.csv' : 'email-traffics.txt', true, 1 ); // skip the first line
    }else{
        phpfmg_admin_header();
        echo "<b>No email traffic log found.</b>";
        phpfmg_admin_footer();
    };

}


function phpfmg_log_delete(){
    $n = isset($_REQUEST['file'])  ? $_REQUEST['file']  : '';
    $files = array(
        1 => PHPFMG_EMAILS_LOGFILE,
        2 => PHPFMG_SAVE_FILE,
    );
    phpfmg_admin_header();

    $file = $files[$n];
    if( is_file($file) ){
        echo unlink($file) ? "It has been deleted!" : "Failed to delete!" ;
    };
    phpfmg_admin_footer();
}


function phpfmg_util_download($file, $filename='', $toCSV = false, $skipN = 0 ){
    if (!is_file($file)) return false ;

    set_time_limit(0);


    $buffer = "";
    $i = 0 ;
    $fp = @fopen($file, 'rb');
    while( !feof($fp)) { 
        $i ++ ;
        $line = fgets($fp);
        if($i > $skipN){ // skip lines
            if( $toCSV ){ 
              $line = str_replace( chr(0x09), ',', $line );
              $buffer .= phpfmg_data2record( $line, false );
            }else{
                $buffer .= $line;
            };
        }; 
    }; 
    fclose ($fp);
  

    
    /*
        If the Content-Length is NOT THE SAME SIZE as the real conent output, Windows+IIS might be hung!!
    */
    $len = strlen($buffer);
    $filename = basename( '' == $filename ? $file : $filename );
    $file_extension = strtolower(substr(strrchr($filename,"."),1));

    switch( $file_extension ) {
        case "pdf": $ctype="application/pdf"; break;
        case "exe": $ctype="application/octet-stream"; break;
        case "zip": $ctype="application/zip"; break;
        case "doc": $ctype="application/msword"; break;
        case "xls": $ctype="application/vnd.ms-excel"; break;
        case "ppt": $ctype="application/vnd.ms-powerpoint"; break;
        case "gif": $ctype="image/gif"; break;
        case "png": $ctype="image/png"; break;
        case "jpeg":
        case "jpg": $ctype="image/jpg"; break;
        case "mp3": $ctype="audio/mpeg"; break;
        case "wav": $ctype="audio/x-wav"; break;
        case "mpeg":
        case "mpg":
        case "mpe": $ctype="video/mpeg"; break;
        case "mov": $ctype="video/quicktime"; break;
        case "avi": $ctype="video/x-msvideo"; break;
        //The following are for extensions that shouldn't be downloaded (sensitive stuff, like php files)
        case "php":
        case "htm":
        case "html": 
                $ctype="text/plain"; break;
        default: 
            $ctype="application/x-download";
    }
                                            

    //Begin writing headers
    header("Pragma: public");
    header("Expires: 0");
    header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
    header("Cache-Control: public"); 
    header("Content-Description: File Transfer");
    //Use the switch-generated Content-Type
    header("Content-Type: $ctype");
    //Force the download
    header("Content-Disposition: attachment; filename=".$filename.";" );
    header("Content-Transfer-Encoding: binary");
    header("Content-Length: ".$len);
    
    while (@ob_end_clean()); // no output buffering !
    flush();
    echo $buffer ;
    
    return true;
 
    
}
?>